//Source file: H:\MIDDLEWARE\SRC\ALKINDI\BUSINESSDATATYPES\MYLISTITEM.JAVA

package Alkindi.Data;

import java.io.Serializable;
import java.sql.Date;

/* 
$Header: MyListItem.java, 5, 12/28/00 1:06:52 PM, Schwartz, Joe$
$Log: 
 5    Alkindi Development1.4         12/28/00 1:06:52 PM  Schwartz, Joe   Added
      version control header info.
 4    Alkindi Development1.3         12/26/00 7:21:16 PM  Schwartz, Joe   
 3    Alkindi Development1.2         12/26/00 6:57:24 PM  Schwartz, Joe   
 2    Alkindi Development1.1         12/18/00 12:05:37 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 1    Alkindi Development1.0         11/11/00 4:57:55 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents an item kept in a user's personal list, called "My List." At present it includes a Recommendation, which itself contains a Product, and the date the item was added to the list.
 */
public class MyListItem implements Serializable 
{
	
	/**
	 * The product represented by an item of a user's personal "My List." A Recommendation object is used instead of a plain Product because the interface is requried to display a predicted rating.
	 */
	public Recommendation rec;
	
	/**
	 * The date this item was added to the list.
	 */
	public Date dateAdded;
	
	public MyListItem() 
	{
	}
	
	/**
	 * Utility constructor.
	 * @roseuid 3A0DA4350148
	 */
	public MyListItem(final Recommendation recIn, final java.sql.Date dateAddedIn) 
	{
		rec = recIn;
		dateAdded = dateAddedIn;
	}
}
